model timeEventExample "Time event demonstration"
  Real h(unit = "m") "Height of ball";
  Real v(unit = "m/s") "Velocity of ball";
  parameter Real g(unit = "m/s2") = -9.81 "Acceleration due to gravity";
initial equation
  h = 30;
  v = 0;
equation
  if time >= 0.5 then
    der(h) = v;
    der(v) = g;
  else
    der(h) = v;
    der(v) = 0;
  end if;
end timeEventExample;
