model bouncingBallWithImport "The 'classic' bouncing ball model with import statement"
  parameter Real e = 0.8 "Coefficient of restitution";
  parameter Modelica.SIunits.Length radius = 0.001 "Radius of ball";
  Modelica.SIunits.Length h "Height of ball";
  Modelica.SIunits.Velocity v "Velocity of ball";
  parameter Modelica.SIunits.Acceleration g = -9.81 "Acceleration due to gravity";
initial equation
  h = 30;
  v = 0;
equation
  v = der(h);
  der(v) = if h <= radius then 0 else g;
  when h < radius then
    reinit(v, -e * pre(v));
  end when;
end bouncingBallWithImport;