package spokenTutorialExamples
  
  class freeFall
    Real h(start = 30, unit = "m");
    Real v(start = 0, unit = "m/s");
    parameter Real g(unit = "m/s2") = -9.81 "Acceleration due to gravity";
  equation
    /* Equations of motion */
    der(h) = v;
    der(v) = g;
  end freeFall;

model bouncingBall 
  parameter Real e = 0.8 "Coefficient of restitution";
  parameter Real radius(unit = "m") = 0.001 "Radius of ball in 'm'";
  Real h(unit = "m") "Height of ball";
  Real v(unit = "m/s") "Velocity of ball";
  parameter Real g(unit = "m/s2") = -9.81 "Acceleration due to gravity";
initial equation
  h = 30;
  v = 0;
equation
  der(h) = v;
  der(v) = g;
  when h <= radius then
    reinit(v, -e * pre(v));
  end when;
end bouncingBall;

  model bouncingBallWithUserTypes "The bouncing ball model with user types"
  /* Type Definitions */
  type Length = Real(unit = "m");
  type Velocity = Real(unit = "m/s");
  parameter Real e = 0.8 "Coefficient of restitution";
  parameter Real radius = 0.001 "Radius of the ball in 'm'";
  Length h "Height of ball";
  Velocity v "Velocity of ball";
  parameter Real g(unit = "m / s2") = -9.81 "Acceleration due to gravity";
  initial equation
    h = 30;
    v = 0;
  equation
    v = der(h);
    der(v) = if h <= radius then 0 else g;
  when h < radius then
    reinit(v, -e * pre(v));
  end when;
  end bouncingBallWithUserTypes;
  


  /* Package that has all models related to the Bouncing Ball phenomenon */
end spokenTutorialExamples;
